#ifndef GAUGECONFIG_GAUGECONFIG_H_
#define GAUGECONFIG_GAUGECONFIG_H_

#include "Gauge_Type.h"


//******************************Algorithm detection mode selection*********************************************//
//#define DETECTION_MODE  (FLASH_DATA_INPUT)
//#define DETECTION_MODE  (COMMUNICATION_DATA_INPUT)
#define DETECTION_MODE  (DETECTION_DATA_INPUT)

//******************************Algorithm data output mode selection*********************************************//
//#define OUTPUT_MODE     (NO_OUTPUT)
#define OUTPUT_MODE     (UART_OUTPUT)

//**********************************Customized configuration settings********************************************//
#define VCELL_FACTOR                                                            (3.2)    //Voltage detection resistor divider (22k+10k)/10k
#define NTC_PAIR_RESISTOR_VALUE                                                 (10000)  //10k
#define ADC_AVERAGE_TIMES                                                       (4)
#define ADC_SAMPLE_TIME                                                         (10)     //Max is 1023, only affect ADC sampling time, ADC conversion time is fixed
#define CIRCUIT_TABLE_LENGTH                                                    (33)      //OCV-SOC-Rcell table

//*****************************************System settings*******************************************************//
#define INTERNAL_REF                                                            (1400)   //1400mV
#define SYSTEM_TIK_SHIFT                                                        (2)      //As the least sys clock is 500ms, we multiply it with 2

extern  tGaugeApplication gaugeApp;
extern  tBattGlobalParams battGlobalParams;
extern  tBattInfoInput battInfoInput;
extern  tBattParamsConfig  battParamsCfg;
extern  tBattCircuitParams circuitParamsTable[CIRCUIT_TABLE_LENGTH];
extern  tVGaugeFilterParams  vGaugeParams;
extern  tOutputParams outputParams;
extern tInputParams inputRarams;
extern tWarningFlags warningFlags;

#endif /* GAUGECONFIG_GAUGECONFIG_H_ */
